import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 *
 * Beschreibung: Vorlage für das Programm Vokabeltrainer
 *
 * @version 1.0 vom 19.01.2023
 * @author Ylva Brandt
 * Dieses Werk ist lizenziert unter einer Creative Commons Namensnennung - Nicht-kommerziell - Weitergabe unter gleichen Bedingungen 4.0 International Lizenz. 
 */

public class Vokabeltrainer extends JFrame {
  // Anfang Attribute
  private JLabel lDeutscheBedeutung = new JLabel();
  private JTextField jTextFieldDeutsch = new JTextField();
  private JLabel lEnglischeBedeutung = new JLabel();
  private JTextField jTextFieldEnglisch = new JTextField();
  private JLabel lRueckmeldung1 = new JLabel();
  private JLabel jLabelAusgabe = new JLabel();
  private JButton bZeigedeutschesWort = new JButton();
  private JButton bZeigeenglischesWort = new JButton();
  private JButton bPruefen = new JButton();
  private JButton bHinzufuegen = new JButton();
  private Vokabel[] vokabeln = new Vokabel[20];
  int freierIndex = 0;
  int aktuell = 0;
  // Ende Attribute
  
  public Vokabeltrainer() { 
    // Frame-Initialisierung
    super();
    vokabeln[0] = new Vokabel("Tisch", "table");
    vokabeln[1] = new Vokabel("Stuhl", "chair");
    vokabeln[2] = new Vokabel("Tür", "door");
    vokabeln[3] = new Vokabel("Apfel", "apple");
    vokabeln[4] = new Vokabel("Eichhörnchen", "squirrel");
    vokabeln[5] = new Vokabel("Informatik", "computer science");
    freierIndex = 6;
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 675; 
    int frameHeight = 300;
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    setTitle("Vokabeltrainer");
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    bHinzufuegen.setBounds(464, 208, 177, 33);
    bHinzufuegen.setText("hinzufügen");
    bHinzufuegen.setMargin(new Insets(2, 2, 2, 2));
    bHinzufuegen.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bHinzufuegen_ActionPerformed(evt);
      }
    });
    cp.add(bHinzufuegen);
    bPruefen.setBounds(464, 144, 177, 33);
    bPruefen.setText("prüfen");
    bPruefen.setMargin(new Insets(2, 2, 2, 2));
    bPruefen.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bPruefen_ActionPerformed(evt);
      }
    });
    cp.add(bPruefen);
    bZeigeenglischesWort.setBounds(464, 80, 177, 33);
    bZeigeenglischesWort.setText("zeige englisches Wort");
    bZeigeenglischesWort.setMargin(new Insets(2, 2, 2, 2));
    bZeigeenglischesWort.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bZeigeenglischesWort_ActionPerformed(evt);
      }
    });
    cp.add(bZeigeenglischesWort);
    bZeigedeutschesWort.setBounds(464, 24, 177, 33);
    bZeigedeutschesWort.setText("zeige deutsches Wort");
    bZeigedeutschesWort.setMargin(new Insets(2, 2, 2, 2));
    bZeigedeutschesWort.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bZeigedeutschesWort_ActionPerformed(evt);
      }
    });
    cp.add(bZeigedeutschesWort);
    jLabelAusgabe.setBounds(144, 160, 265, 33);
    jLabelAusgabe.setText("");
    cp.add(jLabelAusgabe);
    lRueckmeldung1.setBounds(8, 168, 121, 25);
    lRueckmeldung1.setText("Rückmeldung:");
    cp.add(lRueckmeldung1);
    jTextFieldEnglisch.setBounds(152, 80, 257, 33);
    cp.add(jTextFieldEnglisch);
    lEnglischeBedeutung.setBounds(8, 80, 129, 33);
    lEnglischeBedeutung.setText("englische Bedeutung:");
    cp.add(lEnglischeBedeutung);
    jTextFieldDeutsch.setBounds(152, 24, 257, 33);
    cp.add(jTextFieldDeutsch);
    lDeutscheBedeutung.setBounds(8, 24, 127, 33);
    lDeutscheBedeutung.setText("deutsche Bedeutung: ");
    cp.add(lDeutscheBedeutung);
    
    // Ende Komponenten
    
    setVisible(true);
  } // end of public Vokabeltrainer
  
  // Anfang Methoden
  
  public static void main(String[] args) {
    new Vokabeltrainer();
  } // end of main
  
  public void bZeigedeutschesWort_ActionPerformed(ActionEvent evt) {
    aktuell = (int)(Math.random()*freierIndex);
    jTextFieldDeutsch.setText(vokabeln[aktuell].getWortD());
    jTextFieldEnglisch.setText("");
    //es soll nur die englische Bedeutung eingegeben werden können und die deutsche nicht verändert werden, deshalb wird das 
    //Textfeld für die deutsche Bedeutung deaktiviert.
    jTextFieldDeutsch.setEnabled(false);
    jTextFieldEnglisch.setEnabled(true);
  } // end of bZeigedeutschesWort_ActionPerformed

  public void bZeigeenglischesWort_ActionPerformed(ActionEvent evt) {
   
  } // end of bZeigeenglischesWort_ActionPerformed

  public void bPruefen_ActionPerformed(ActionEvent evt) {
    String wd = jTextFieldDeutsch.getText();
    String we = jTextFieldEnglisch.getText();
    boolean richtig = vokabeln[aktuell].pruefen(wd, we);
    if(richtig) jLabelAusgabe.setText("Das war richtig, super");
    else jLabelAusgabe.setText("Leider falsch");
    jTextFieldDeutsch.setEnabled(true);
    jTextFieldEnglisch.setEnabled(true);
  } // end of bPruefen_ActionPerformed
  
  //doppelte Einträge sind in dieser Implementierung noch möglich
  public void bHinzufuegen_ActionPerformed(ActionEvent evt) {
    if(freierIndex < vokabeln.length){
      String wd = jTextFieldDeutsch.getText();
      String we = jTextFieldEnglisch.getText();
      vokabeln[freierIndex] = new Vokabel(wd, we);
      freierIndex++;
      jLabelAusgabe.setText("Hinzugefügt, es haben noch "
       + (vokabeln.length - freierIndex) + " Vokabeln Platz.");
    } else {
      jLabelAusgabe.setText("In der Vokabelliste ist kein Platz mehr.");
    } // end of if-else
  } // end of bHinzufuegen_ActionPerformed

  // Ende Methoden
} // end of class Vokabeltrainer
